<?php
/**
 * Whole Prices Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Group_prices extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Group_prices_model');
		$this->load->model('Items_model');
	}

 	public function edit($id)
	{
		$title       = "Harga Grup Pelanggan";
		$where       = array('item_id' => $id);
		$header_data = $this->Items_model->get_data($where)->row_array();
		
		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		
		$this->twiggy_display('adm/group_prices/edit', $data);
	}

	public function get_data_detail()
	{	
		$id    = $this->input->post("id");

		$data = [];
		$get_data = $this->Group_prices_model->get_data_group_customer()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{
				$price = 0;
				$where = array('a.group_customer_id' => $get_row->group_customer_id, 'a.item_id' => $id);
				$order = "a.timestamp desc";
				$get_price = $this->Group_prices_model->get_data_group_price($where, $order)->row();
				if($get_price){
					$price = $get_price->price;
				}

				$data[] = array(
					'no'                => $no,
					'group_customer_id' => $get_row->group_customer_id,
					'group_customer'    => $get_row->group_customer_name,
					'price'             => number_format($price),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function save()
	{	
		$id       = $this->input->post('id');
		$vuedata  = $this->input->post('vuedata');
		
		$where    = array('a.item_id' => $id);
		$get_data = $this->Group_prices_model->get_data_group_price($where)->result();
		$detail_data = [];

		if($vuedata == null){
			$delete_detail = $this->Group_prices_model->delete($id);
			if($delete_detail)
			{
				$msg    = "Berhasil menyimpan data";
				$status = "success";
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
		}else{
			$delete_detail = $this->Group_prices_model->delete($id);

			foreach($vuedata as $row)
			{
				$detail_data[] = [
					'item_id'           => $id,
					'group_customer_id' => $row['group_customer_id'],
					'price'             => trims($row['price']),
					'is_active'         => '1',
				];
			}

			$save_detail = $this->Group_prices_model->save($detail_data, true);
			
			if($save_detail)
			{
				$msg    = "Berhasil menyimpan data";
				$status = "success";
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $id
		];
		output_json($response);
	}

}

?>
